<?php

namespace Database\Seeders\Tenant;

use Database\Seeders\Tenant\BarcodeSeeder;
use Database\Seeders\Tenant\ExternalServicesSeeder;
use Database\Seeders\Tenant\LanguagesTableSeeder;
use Database\Seeders\Tenant\TranslationsTableSeeder;
use Database\Seeders\Tenant\InvoiceSettingsSeeder;
use Illuminate\Database\Seeder;

use Illuminate\Support\Facades\DB;

class TenantDatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public static $tenantData = [];

    public function run()
    {
        $this->call(BarcodeSeeder::class);
        $this->call(ExternalServicesSeeder::class);
        $this->call(LanguagesTableSeeder::class);
        $this->call(TranslationsTableSeeder::class);
        $this->call(InvoiceSettingsSeeder::class);

        if (!DB::table('general_settings')->count()) {
            DB::table('general_settings')->insert([
                [
                    'id' => 1,
                    'site_title' => !empty(self::$tenantData) ? self::$tenantData['site_title'] : 'SalePro POS SaaS',
                    'site_logo' => !empty(self::$tenantData) ? self::$tenantData['site_logo'] : '20250102042651.png',
                    'is_rtl' => 0,
                    'currency' => '1',
                    'package_id' => !empty(self::$tenantData) ? self::$tenantData['package_id'] : 0,
                    'subscription_type' => !empty(self::$tenantData) ? self::$tenantData['subscription_type'] : 'monthly',
                    'staff_access' => 'own',
                    'without_stock' => 'no',
                    'date_format' => 'd/m/Y',
                    'developed_by' => !empty(self::$tenantData) ? self::$tenantData['developed_by'] : 'Lioncoders',
                    'invoice_format' => 'standard',
                    'decimal' => 2,
                    'state' => 1,
                    'theme' => 'default.css',
                    'modules' => !empty(self::$tenantData) ? self::$tenantData['modules'] : NULL,
                    'currency_position' => 'prefix',
                    'expiry_date' => !empty(self::$tenantData) ? self::$tenantData['expiry_date'] : '1970-01-01',
                    'expiry_type' => 'days',
                    'expiry_value' => '0',
                    'is_zatca' => NULL,
                    'company_name' => NULL,
                    'vat_registration_number' => NULL,
                    'is_packing_slip' => 0,
                ]
            ]);
        }

        if (!DB::table('users')->count()) {
            DB::table('users')->insert([
                [
                    'id' => 1,
                    'name' => !empty(self::$tenantData) ? self::$tenantData['name'] : 'admin',
                    'email' => !empty(self::$tenantData) ? self::$tenantData['email'] : 'admin@gmail.com',
                    'password' => !empty(self::$tenantData) ? self::$tenantData['password'] : '$2y$10$DWAHTfjcvwCpOCXaJg11MOhsqns03uvlwiSUOQwkHL2YYrtrXPcL6',
                    'remember_token' => '6mN44MyRiQZfCi0QvFFIYAU9LXIUz9CdNIlrRS5Lg8wBoJmxVu8auzTP42ZW',
                    'phone' => !empty(self::$tenantData) ? self::$tenantData['phone'] : '12112',
                    'company_name' => !empty(self::$tenantData) ? self::$tenantData['company_name'] : 'lioncoders',
                    'role_id' => 1,
                    'biller_id' => NULL,
                    'warehouse_id' => NULL,
                    'is_active' => 1,
                    'is_deleted' => 0,
                ]
            ]);
        }

        if (!DB::table('roles')->count()) {
            DB::table('roles')->insert([
                [
                    'id' => 1,
                    'name' => 'Admin',
                    'description' => 'admin can access all data...',
                    'is_active' => 1,
                    'guard_name' => 'web',
                ],
                [
                    'id' => 2,
                    'name' => 'Owner',
                    'description' => 'Staff of shop',
                    'is_active' => 1,
                    'guard_name' => 'web',
                ],
                [
                    'id' => 4,
                    'name' => 'staff',
                    'description' => 'staff has specific acess...',
                    'is_active' => 1,
                    'guard_name' => 'web',
                ],
                [
                    'id' => 5,
                    'name' => 'Customer',
                    'description' => NULL,
                    'is_active' => 1,
                    'guard_name' => 'web',
                ]
            ]);
        }

        ///permissions table data insert start///
        $existing_permissions = DB::table('permissions')
        ->select('name', 'guard_name')
        ->get();

        $existingMap = [];

        foreach ($existing_permissions as $item) {
            $existingMap[$item->name . '|' . $item->guard_name] = true;
        }

        $permission_data = [
                [
                    'id' => 4,
                    'name' => 'products-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 5,
                    'name' => 'products-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 6,
                    'name' => 'products-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 7,
                    'name' => 'products-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 8,
                    'name' => 'purchases-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 9,
                    'name' => 'purchases-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 10,
                    'name' => 'purchases-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 11,
                    'name' => 'purchases-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 12,
                    'name' => 'sales-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 13,
                    'name' => 'sales-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 14,
                    'name' => 'sales-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 15,
                    'name' => 'sales-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 16,
                    'name' => 'quotes-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 17,
                    'name' => 'quotes-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 18,
                    'name' => 'quotes-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 19,
                    'name' => 'quotes-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 20,
                    'name' => 'transfers-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 21,
                    'name' => 'transfers-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 22,
                    'name' => 'transfers-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 23,
                    'name' => 'transfers-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 24,
                    'name' => 'returns-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 25,
                    'name' => 'returns-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 26,
                    'name' => 'returns-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 27,
                    'name' => 'returns-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 28,
                    'name' => 'customers-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 29,
                    'name' => 'customers-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 30,
                    'name' => 'customers-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 31,
                    'name' => 'customers-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 32,
                    'name' => 'suppliers-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 33,
                    'name' => 'suppliers-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 34,
                    'name' => 'suppliers-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 35,
                    'name' => 'suppliers-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 36,
                    'name' => 'product-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 37,
                    'name' => 'purchase-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 38,
                    'name' => 'sale-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 39,
                    'name' => 'customer-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 40,
                    'name' => 'due-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 41,
                    'name' => 'users-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 42,
                    'name' => 'users-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 43,
                    'name' => 'users-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 44,
                    'name' => 'users-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 45,
                    'name' => 'profit-loss',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 46,
                    'name' => 'best-seller',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 47,
                    'name' => 'daily-sale',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 48,
                    'name' => 'monthly-sale',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 49,
                    'name' => 'daily-purchase',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 50,
                    'name' => 'monthly-purchase',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 51,
                    'name' => 'payment-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 52,
                    'name' => 'warehouse-stock-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 53,
                    'name' => 'product-qty-alert',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 54,
                    'name' => 'supplier-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 55,
                    'name' => 'expenses-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 56,
                    'name' => 'expenses-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 57,
                    'name' => 'expenses-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 58,
                    'name' => 'expenses-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 59,
                    'name' => 'general_setting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 60,
                    'name' => 'mail_setting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 61,
                    'name' => 'pos_setting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 62,
                    'name' => 'hrm_setting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 63,
                    'name' => 'purchase-return-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 64,
                    'name' => 'purchase-return-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 65,
                    'name' => 'purchase-return-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 66,
                    'name' => 'purchase-return-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 67,
                    'name' => 'account-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 68,
                    'name' => 'balance-sheet',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 69,
                    'name' => 'account-statement',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 70,
                    'name' => 'department',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 71,
                    'name' => 'attendance',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 72,
                    'name' => 'payroll',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 73,
                    'name' => 'employees-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 74,
                    'name' => 'employees-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 75,
                    'name' => 'employees-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 76,
                    'name' => 'employees-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 77,
                    'name' => 'user-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 78,
                    'name' => 'stock_count',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 79,
                    'name' => 'adjustment',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 80,
                    'name' => 'sms_setting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 81,
                    'name' => 'create_sms',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 82,
                    'name' => 'print_barcode',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 83,
                    'name' => 'empty_database',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 84,
                    'name' => 'customer_group',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 85,
                    'name' => 'unit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 86,
                    'name' => 'tax',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 87,
                    'name' => 'gift_card',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 88,
                    'name' => 'coupon',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 89,
                    'name' => 'holiday',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 90,
                    'name' => 'warehouse-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 91,
                    'name' => 'warehouse',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 92,
                    'name' => 'brand',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 93,
                    'name' => 'billers-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 94,
                    'name' => 'billers-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 95,
                    'name' => 'billers-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 96,
                    'name' => 'billers-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 97,
                    'name' => 'money-transfer',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 98,
                    'name' => 'category',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 99,
                    'name' => 'delivery',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 100,
                    'name' => 'send_notification',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 101,
                    'name' => 'today_sale',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 102,
                    'name' => 'today_profit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 103,
                    'name' => 'currency',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 104,
                    'name' => 'backup_database',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 105,
                    'name' => 'reward_point_setting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 106,
                    'name' => 'revenue_profit_summary',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 107,
                    'name' => 'cash_flow',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 108,
                    'name' => 'monthly_summary',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 109,
                    'name' => 'yearly_report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 110,
                    'name' => 'discount_plan',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 111,
                    'name' => 'discount',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 112,
                    'name' => 'product-expiry-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 113,
                    'name' => 'purchase-payment-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 114,
                    'name' => 'purchase-payment-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 115,
                    'name' => 'purchase-payment-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 116,
                    'name' => 'purchase-payment-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 117,
                    'name' => 'sale-payment-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 118,
                    'name' => 'sale-payment-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 119,
                    'name' => 'sale-payment-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 120,
                    'name' => 'sale-payment-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 121,
                    'name' => 'all_notification',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 122,
                    'name' => 'sale-report-chart',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 123,
                    'name' => 'dso-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 124,
                    'name' => 'product_history',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 125,
                    'name' => 'supplier-due-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 126,
                    'name' => 'custom_field',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 127,
                    'name' => 'incomes-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 128,
                    'name' => 'incomes-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 129,
                    'name' => 'incomes-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 130,
                    'name' => 'incomes-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 131,
                    'name' => 'packing_slip_challan',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 132,
                    'name' => 'biller-report',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 133,
                    'name' => 'payment_gateway_setting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 134,
                    'name' => 'barcode_setting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 135,
                    'name' => 'language_setting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 136,
                    'name' => 'addons',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 137,
                    'name' => 'account-selection',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 138,
                    'name' => 'invoice_setting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 139,
                    'name' => 'invoice_create_edit_delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 140,
                    'name' => 'handle_discount',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 145,
                    'name' => 'products-import',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 146,
                    'name' => 'purchases-import',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 147,
                    'name' => 'sales-import',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 148,
                    'name' => 'customers-import',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 149,
                    'name' => 'billers-import',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 150,
                    'name' => 'suppliers-import',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 151,
                    'name' => 'categories-add',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 152,
                    'name' => 'categories-import',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 153,
                    'name' => 'categories-index',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 154,
                    'name' => 'categories-edit',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 155,
                    'name' => 'categories-delete',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 156,
                    'name' => 'role_permission',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 157,
                    'name' => 'cart-product-update',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 158,
                    'name' => 'transfers-import',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 159,
                    'name' => 'change_sale_date',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 160,
                    'name' => 'sidebar_product',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 161,
                    'name' => 'sidebar_purchase',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 162,
                    'name' => 'sidebar_sale',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 163,
                    'name' => 'sidebar_quotation',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 164,
                    'name' => 'sidebar_transfer',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 165,
                    'name' => 'sidebar_expense',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 166,
                    'name' => 'sidebar_income',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 167,
                    'name' => 'sidebar_accounting',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 168,
                    'name' => 'sidebar_hrm',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 169,
                    'name' => 'sidebar_people',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 170,
                    'name' => 'sidebar_reports',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 171,
                    'name' => 'sidebar_settings',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 172,
                    'name' => 'sale_export',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 173,
                    'name' => 'product_export',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 174,
                    'name' => 'purchase_export',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 175,
                    'name' => 'designations',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 176,
                    'name' => 'shift',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 177,
                    'name' => 'overtime',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 178,
                    'name' => 'leave-type',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 179,
                    'name' => 'leave',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 180,
                    'name' => 'hrm-panel',
                    'guard_name' => 'web',
                ],
                [
                    'id' => 181,
                    'name' => 'sale-agents',
                    'guard_name' => 'web',
                ],
        ];

        $insertData = [];

        foreach ($permission_data as $row) {
            $lookupKey = $row['name'] . '|' . $row['guard_name'];

            if (!isset($existingMap[$lookupKey])) {
                $insertData[] = [
                    'id' => $row['id'],
                    'name' => $row['name'],
                    'guard_name' => $row['guard_name']
                ];
            }
        }

        if (!empty($insertData)) {
            DB::table('permissions')->insert($insertData);
        }
        ///permissions table data insert end///

        ///role_has_permissions table data insert start///
        $existing_role_has_permissions = DB::table('role_has_permissions')
        ->select('permission_id', 'role_id')
        ->get();

        $existingMap = [];

        foreach ($existing_role_has_permissions as $item) {
            $existingMap[$item->permission_id . '|' . $item->role_id] = true;
        }

        $basic_permissions_role = [];

        if(!config('database.connections.saleprosaas_landlord')) {
            foreach ($permission_data as $row) {
                $basic_permissions_role[] = [
                    'permission_id' => $row['id'],
                    'role_id' => 1,
                ];
            }
        }
        else {
            $basic_permissions_role = [
                [
                    'permission_id' => 4,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 5,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 6,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 7,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 8,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 9,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 10,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 11,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 12,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 13,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 14,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 15,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 28,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 29,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 30,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 31,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 32,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 33,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 34,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 35,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 41,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 42,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 43,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 44,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 59,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 60,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 61,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 80,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 81,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 82,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 83,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 84,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 85,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 86,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 87,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 88,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 91,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 92,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 93,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 94,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 95,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 96,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 98,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 100,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 101,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 102,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 103,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 104,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 105,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 106,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 107,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 108,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 109,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 110,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 111,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 113,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 114,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 115,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 116,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 117,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 118,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 119,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 120,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 121,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 124,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 126,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 131,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 133,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 134,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 135,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 137,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 138,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 139,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 140,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 145,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 146,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 147,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 148,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 149,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 150,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 151,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 152,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 153,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 154,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 155,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 156,
                    'role_id' => 1,
                ],
                [
                    'permission_id' => 157,
                    'role_id' => 1,
                ]
            ];
        }

        $merged_permissions_role = !empty(self::$tenantData) ? array_merge($basic_permissions_role, self::$tenantData['package_permissions_role']) : $basic_permissions_role;

        $insertData = [];

        foreach ($merged_permissions_role as $row) {
            $lookupKey = $row['permission_id'] . '|' . $row['role_id'];

            if (!isset($existingMap[$lookupKey])) {
                $insertData[] = [
                    'permission_id' => $row['permission_id'],
                    'role_id' => $row['role_id'],
                ];
            }
        }

        if (!empty($insertData)) {
            DB::table('role_has_permissions')->insert($insertData);
        }
        ///role_has_permissions table data insert end///

        if (!DB::table('accounts')->count()) {
            DB::table('accounts')->insert([
                [
                    'id' => 1,
                    'account_no' => '019912229',
                    'name' => 'Sales Account',
                    'initial_balance' => 0.0,
                    'total_balance' => 0.0,
                    'note' => 'This is the default account.',
                    'is_default' => 1,
                    'is_active' => 1,
                    'code' => NULL,
                    'type' => 'Bank Account',
                    'parent_account_id' => NULL,
                    'is_payment' => 1,
                ],
            ]);
        }

        if (!DB::table('billers')->count()) {
            DB::table('billers')->insert([
                [
                    'id' => 1,
                    'name' => 'Test Biller',
                    'image' => NULL,
                    'company_name' => 'Test Company',
                    'vat_number' => NULL,
                    'email' => 'test@gmail.com',
                    'phone_number' => '12312',
                    'address' => 'Test address',
                    'city' => 'Test City',
                    'state' => NULL,
                    'postal_code' => NULL,
                    'country' => NULL,
                    'is_active' => 1,
                ]
            ]);
        }

        if (!DB::table('brands')->count()) {
            DB::table('brands')->insert([
                [
                    'id' => 1,
                    'title' => 'Apple',
                    'image' => '20240114102326.png',
                    'is_active' => 1,
                ],
                [
                    'id' => 2,
                    'title' => 'Samsung',
                    'image' => '20240114102343.png',
                    'is_active' => 1,
                ],
                [
                    'id' => 3,
                    'title' => 'Huawei',
                    'image' => '20240114102512.png',
                    'is_active' => 1,
                ],
                [
                    'id' => 4,
                    'title' => 'Xiaomi',
                    'image' => '20240114103640.png',
                    'is_active' => 1,
                ],
                [
                    'id' => 5,
                    'title' => 'Whirlpool',
                    'image' => '20240114103701.png',
                    'is_active' => 1,
                ],
                [
                    'id' => 6,
                    'title' => 'Nestle',
                    'image' => '20240114103717.png',
                    'is_active' => 1,
                ],
                [
                    'id' => 7,
                    'title' => 'Kraft',
                    'image' => '20240114103851.png',
                    'is_active' => 1,
                ],
                [
                    'id' => 8,
                    'title' => 'Kellogs',
                    'image' => '20240114103906.png',
                    'is_active' => 1,
                ]
            ]);
        }

        if (!DB::table('categories')->count()) {
            DB::table('categories')->insert([
                [
                    'id' => 1,
                    'name' => 'Smartphone & Gadgets',
                    'image' => NULL,
                    'parent_id' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 2,
                    'name' => 'Phone Accessories',
                    'image' => NULL,
                    'parent_id' => 1,
                    'is_active' => 1,
                ],
                [
                    'id' => 3,
                    'name' => 'iPhone',
                    'image' => NULL,
                    'parent_id' => 1,
                    'is_active' => 1,
                ],
                [
                    'id' => 4,
                    'name' => 'Samsung',
                    'image' => NULL,
                    'parent_id' => 1,
                    'is_active' => 1,
                ],
                [
                    'id' => 5,
                    'name' => 'Phone Cases',
                    'image' => NULL,
                    'parent_id' => 1,
                    'is_active' => 1,
                ],
                [
                    'id' => 6,
                    'name' => 'Laptops & Computers',
                    'image' => NULL,
                    'parent_id' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 7,
                    'name' => 'Keyboards',
                    'image' => NULL,
                    'parent_id' => 6,
                    'is_active' => 1,
                ],
                [
                    'id' => 8,
                    'name' => 'Laptop Bags',
                    'image' => NULL,
                    'parent_id' => 6,
                    'is_active' => 1,
                ],
                [
                    'id' => 9,
                    'name' => 'Mouses',
                    'image' => NULL,
                    'parent_id' => 6,
                    'is_active' => 1,
                ],
                [
                    'id' => 10,
                    'name' => 'Webcams',
                    'image' => NULL,
                    'parent_id' => 6,
                    'is_active' => 1,
                ],
                [
                    'id' => 11,
                    'name' => 'Monitors',
                    'image' => NULL,
                    'parent_id' => 6,
                    'is_active' => 1,
                ],
                [
                    'id' => 12,
                    'name' => 'Smartwatches',
                    'image' => NULL,
                    'parent_id' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 13,
                    'name' => 'Sport Watches',
                    'image' => NULL,
                    'parent_id' => 12,
                    'is_active' => 1,
                ],
                [
                    'id' => 14,
                    'name' => 'Kids Watches',
                    'image' => NULL,
                    'parent_id' => 12,
                    'is_active' => 1,
                ],
                [
                    'id' => 15,
                    'name' => 'Women Watches',
                    'image' => NULL,
                    'parent_id' => 12,
                    'is_active' => 1,
                ],
                [
                    'id' => 16,
                    'name' => 'Men Watches',
                    'image' => NULL,
                    'parent_id' => 12,
                    'is_active' => 1,
                ],
                [
                    'id' => 23,
                    'name' => 'TVs, Audio & Video',
                    'image' => NULL,
                    'parent_id' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 24,
                    'name' => 'Television Accessories',
                    'image' => NULL,
                    'parent_id' => 23,
                    'is_active' => 1,
                ],
                [
                    'id' => 25,
                    'name' => 'HD, DVD Players',
                    'image' => NULL,
                    'parent_id' => 23,
                    'is_active' => 1,
                ],
                [
                    'id' => 26,
                    'name' => 'TV-DVD Combos',
                    'image' => NULL,
                    'parent_id' => 23,
                    'is_active' => 1,
                ],
                [
                    'id' => 27,
                    'name' => 'Projectors',
                    'image' => NULL,
                    'parent_id' => 23,
                    'is_active' => 1,
                ],
                [
                    'id' => 28,
                    'name' => 'Projection Screen',
                    'image' => NULL,
                    'parent_id' => 23,
                    'is_active' => 1,
                ],
                [
                    'id' => 29,
                    'name' => 'Fruits & Vegetables',
                    'image' => NULL,
                    'parent_id' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 30,
                    'name' => 'Dairy & Egg',
                    'image' => NULL,
                    'parent_id' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 31,
                    'name' => 'Meat & Fish',
                    'image' => NULL,
                    'parent_id' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 33,
                    'name' => 'Candy & Chocolates',
                    'image' => NULL,
                    'parent_id' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 39,
                    'name' => 'Clothing',
                    'image' => NULL,
                    'parent_id' => NULL,
                    'is_active' => 1,
                ]
            ]);
        }

        if (!DB::table('currencies')->count()) {
            DB::table('currencies')->insert([
                [
                    'id' => 1,
                    'name' => 'US Dollar',
                    'code' => 'USD',
                    'exchange_rate' => 1.0,
                    'is_active' => 1,
                ]
            ]);
        }

        if (!DB::table('customer_groups')->count()) {
            DB::table('customer_groups')->insert([
                [
                    'id' => 1,
                    'name' => 'General',
                    'percentage' => '0',
                    'is_active' => 1,
                ]
            ]);
        }

        if (!DB::table('customers')->count()) {
            DB::table('customers')->insert([
                [
                    'id' => 1,
                    'customer_group_id' => 1,
                    'user_id' => NULL,
                    'name' => 'John Doe',
                    'company_name' => 'Test Company',
                    'email' => 'john@gmail.com',
                    'phone_number' => '231312',
                    'tax_no' => NULL,
                    'address' => 'Test address',
                    'city' => 'Test City',
                    'state' => NULL,
                    'postal_code' => NULL,
                    'country' => NULL,
                    'points' => NULL,
                    'is_active' => 1,
                    'deposit' => NULL,
                    'expense' => NULL,
                ]
            ]);
        }

        if (!DB::table('pos_setting')->count()) {
            DB::table('pos_setting')->insert([
                [
                    'id' => 1,
                    'customer_id' => 1,
                    'warehouse_id' => 1,
                    'biller_id' => 1,
                    'product_number' => 2,
                    'keybord_active' => 1,
                    'is_table' => 0,
                    'send_sms' => 0,
                    'stripe_public_key' => NULL,
                    'stripe_secret_key' => NULL,
                    'paypal_live_api_username' => NULL,
                    'paypal_live_api_password' => NULL,
                    'paypal_live_api_secret' => NULL,
                    'payment_options' => 'cash,card,cheque,gift_card,deposit,paypal',
                    'invoice_option' => 'thermal',
                    'thermal_invoice_size' => '80',
                ]
            ]);
        }

        if (!DB::table('product_purchases')->count()) {
            DB::table('product_purchases')->insert([
                [
                    'id' => 1,
                    'purchase_id' => 1,
                    'product_id' => 1,
                    'product_batch_id' => NULL,
                    'variant_id' => NULL,
                    'imei_number' => NULL,
                    'qty' => 10.0,
                    'recieved' => 10.0,
                    'return_qty' => 0.0,
                    'purchase_unit_id' => 1,
                    'net_unit_cost' => 10.0,
                    'discount' => 0.0,
                    'tax_rate' => 10.0,
                    'tax' => 10.0,
                    'total' => 110.0,
                ]
            ]);
        }

        if (!DB::table('product_warehouse')->count()) {
            DB::table('product_warehouse')->insert([
                [
                    'id' => 1,
                    'product_id' => '1',
                    'product_batch_id' => NULL,
                    'variant_id' => NULL,
                    'imei_number' => NULL,
                    'warehouse_id' => 1,
                    'qty' => 10.0,
                    'price' => 20.0,
                ]
            ]);
        }

        if (!DB::table('products')->count()) {
            DB::table('products')->insert([
                [
                    'id' => 1,
                    'name' => 'Zenbook 14 OLED (UX3402)｜Laptops For Home – ASUS',
                    'code' => '59028109',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 1099.99,
                    'price' => 1299.99,
                    'wholesale_price' => NULL,
                    'qty' => 624.7,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => 1,
                    'promotion_price' => '1050.99',
                    'starting_date' => '2024-01-08',
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202401081146401.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 2,
                    'name' => '2021 Apple 12.9-inch iPad Pro Wi-Fi 512GB',
                    'code' => '20358923',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 3,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 1000.0,
                    'price' => 1249.0,
                    'wholesale_price' => NULL,
                    'qty' => -152.5,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => 1,
                    'promotion_price' => '1200.00',
                    'starting_date' => '2024-01-08',
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202401081246041.png,202401081246062.png,202401081246063.png,202401081246064.png',
                    'file' => NULL,
                    'is_embeded' => 0,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => 0,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 3,
                    'name' => 'Apple iPhone 11 (4GB-64GB) Black',
                    'code' => '49251814',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 300.0,
                    'price' => 350.0,
                    'wholesale_price' => NULL,
                    'qty' => -47.7,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => 1,
                    'promotion_price' => '330',
                    'starting_date' => '2024-01-08',
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202401081255081.png,202401081255112.png,202401081255123.png,202401081255134.png,202401081255135.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 4,
                    'name' => 'Samsung Galaxy Chromebook Go, 14″ HD LED, Intel Celeron N4500',
                    'code' => '28090345',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 900.0,
                    'price' => 1050.0,
                    'wholesale_price' => NULL,
                    'qty' => -18.78,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202401080121221.png,202401080121242.png,202401080121243.png,202401080121254.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 5,
                    'name' => 'SAMSUNG Galaxy Book Pro 15.6 Laptop – Intel Core i5',
                    'code' => '67015642',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 950.99,
                    'price' => 1150.99,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202401080124321.png,202401080124342.png,202401080124353.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 6,
                    'name' => 'Microsoft – Surface Laptop 4 13.5” Touch-Screen – AMD Ryzen 5',
                    'code' => '24005329',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 3,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 999.99,
                    'price' => 1111.99,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401080127451.png,202401080127462.png,202401080127473.jpg,202401080127484.jpg,202401080127485.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 7,
                    'name' => 'Acer Chromebook 315, 15.6 HD – Intel Celeron N4000',
                    'code' => '30798200',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 4,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 899.99,
                    'price' => 999.99,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202401080130241.png,202401080130242.png,202401080130253.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 8,
                    'name' => 'HP Victus 16-e00244AX GTX 1650 Gaming Laptop 16.1” FHD 144Hz',
                    'code' => '81526930',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 4,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 1199.0,
                    'price' => 1300.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202401080134061.png,202401080134072.png,202401080134073.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 9,
                    'name' => 'Epson Inkjet WorkForce Pro WF-3820DWF',
                    'code' => '20142029',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 399.0,
                    'price' => 559.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401080141091.png,202401080141102.png,202401080141103.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 10,
                    'name' => 'iPhone 14 Pro 256GB Gold',
                    'code' => '29733132',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 990.0,
                    'price' => 1250.0,
                    'wholesale_price' => NULL,
                    'qty' => 84.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401080143591.png,202401080144002.png,202401080144013.png,202401080144014.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 14,
                    'name' => 'Sony Bravia 55X90J 4K Ultra HD 55″ 140 Screen Google Smart LED TV',
                    'code' => '16530612',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 3,
                    'category_id' => 23,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 350.0,
                    'price' => 499.0,
                    'wholesale_price' => NULL,
                    'qty' => -1.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => NULL,
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 15,
                    'name' => 'Samsung 43AU7000 4K Ultra HD 43″ 109 Screen Smart LED TV',
                    'code' => '73189124',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 23,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 499.0,
                    'price' => 547.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401130357131.png,202401130357152.png,202401130357153.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 16,
                    'name' => 'Apple TV HD 32GB (2nd Generation)',
                    'code' => '71493353',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 23,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 79.0,
                    'price' => 109.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401130401491.png,202401130401522.png,202401130401533.png,202401130401544.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 17,
                    'name' => 'Apple Watch SE GPS + Cellular 40mm Space Gray',
                    'code' => '92178104',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 12,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 349.0,
                    'price' => 499.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401130410191.png,202401130410222.jpg,202401130410233.jpg',
                    'file' => NULL,
                    'is_embeded' => 0,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => 0,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                    <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 18,
                    'name' => 'Xbox One Wireless Controller Black Color',
                    'code' => '93060790',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => NULL,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 459.0,
                    'price' => 599.0,
                    'wholesale_price' => NULL,
                    'qty' => -5.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202401150808421.jpg,202401150808432.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<div class=@item-description@>
                        <p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                        <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>
                    </div>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 19,
                    'name' => 'Apple iPhone XS Max-64GB -white',
                    'code' => '22061536',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 899.0,
                    'price' => 1059.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202401150814131.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<div class=@item-description@>
                        <p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                        <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>
                    </div>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 20,
                    'name' => 'Apple Watch Series 8 GPS 45mm Midnight Aluminum Case',
                    'code' => '31429623',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 12,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 399.0,
                    'price' => 499.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401151009571.png,202401151009582.png,202401151009583.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<div class=@item-description@>
                        <p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                        <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>
                    </div>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 21,
                    'name' => 'Huawei Watch GT 2 Sport Stainless Steel 46mm',
                    'code' => '02456392',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 3,
                    'category_id' => 12,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 369.0,
                    'price' => 599.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => 1,
                    'promotion_price' => '499',
                    'starting_date' => '2024-01-15',
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401151013061.png,202401151013062.png,202401151013073.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<div class=@item-description@>
                        <p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                        <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>
                    </div>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 22,
                    'name' => 'Samsung Galaxy Active 2 R835U Smartwatch 40mm',
                    'code' => '10203743',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 12,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 275.0,
                    'price' => 399.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401151019301.png,202401151019302.png,202401151019313.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<div class=@item-description@>
                        <p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                        <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>
                    </div>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 23,
                    'name' => 'Canon EOS R10 RF-S 18-45 IS STM',
                    'code' => '13929367',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 17,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 439.0,
                    'price' => 577.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401151024231.png,202401151024232.png,202401151024233.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<div class=@item-description@>
                        <p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                        <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>
                    </div>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 24,
                    'name' => 'Sony A7 III Mirrorless Camera Body Only',
                    'code' => '99421096',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 299.0,
                    'price' => 379.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202401151026581.png,202401151026592.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<div class=@item-description@>
                        <p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                        <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>
                    </div>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 25,
                    'name' => 'WOLFANG GA420 Action Camera 4K 60FPS 24MP',
                    'code' => '99218280',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 4,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 130.0,
                    'price' => 157.99,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401151029321.png,202401151029332.jpg,202401151029343.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<div class=@item-description@>
                        <p>Quisque varius diam vel metus mattis, id aliquam diam rhoncus. Proin vitae magna in dui finibus malesuada et at nulla. Morbi elit ex, viverra vitae ante vel, blandit feugiat ligula. Fusce fermentum iaculis nibh, at sodales leo maximus a. Nullam ultricies sodales nunc, in pellentesque lorem mattis quis. Cras imperdiet est in nunc tristique lacinia. Nullam aliquam mauris eu accumsan tincidunt. Suspendisse velit ex, aliquet vel ornare vel, dignissim a tortor.</p>
                        <p>Morbi ut sapien vitae odio accumsan gravida. Morbi vitae erat auctor, eleifend nunc a, lobortis neque. Praesent aliquam dignissim viverra. Maecenas lacus odio, feugiat eu nunc sit amet, maximus sagittis dolor. Vivamus nisi sapien, elementum sit amet eros sit amet, ultricies cursus ipsum. Sed consequat luctus ligula. Curabitur laoreet rhoncus blandit. Aenean vel diam ut arcu pharetra dignissim ut sed leo. Vivamus faucibus, ipsum in vestibulum vulputate, lorem orci convallis quam, sit amet consequat nulla felis pharetra lacus. Duis semper erat mauris, sed egestas purus commodo vel.</p>
                    </div>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 26,
                    'name' => 'Fresh Organic Navel Orange',
                    'code' => '33887520',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => NULL,
                    'category_id' => 29,
                    'unit_id' => 4,
                    'purchase_unit_id' => 4,
                    'sale_unit_id' => 4,
                    'cost' => 2.99,
                    'price' => 3.99,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401151115301.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Fresh Organic Navel Orange</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 27,
                    'name' => 'Banana (pack of 12)',
                    'code' => '27583341',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => NULL,
                    'category_id' => 29,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 0.89,
                    'price' => 1.29,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401151118271.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 28,
                    'name' => 'Water Melon ~ 3KG',
                    'code' => '19186147',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => NULL,
                    'category_id' => 29,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 2.39,
                    'price' => 3.3,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401151142511.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Water Melon ~ 3KG</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 0,
                ],
                [
                    'id' => 29,
                    'name' => 'Gala Original Apple - 1KG',
                    'code' => '80912386',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => NULL,
                    'category_id' => 29,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 2.39,
                    'price' => 3.19,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202401151144271.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Gala Original Apple - 1KG</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 31,
                    'name' => 'Men&#039;s Premium Egyptian Cotton T-shirt',
                    'code' => '30282941',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 16,
                    'category_id' => 39,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 50.5,
                    'price' => 70.99,
                    'wholesale_price' => NULL,
                    'qty' => -13.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 1,
                    'tax_method' => 2,
                    'image' => '202402040508081.jpg',
                    'file' => NULL,
                    'is_embeded' => 0,
                    'is_variant' => 1,
                    'is_batch' => NULL,
                    'is_diffPrice' => 0,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => '["Size","Color"]',
                    'variant_value' => '["S,M,L,XL,XXL","red,green,blue"]',
                    'is_active' => 1,
                ],
                [
                    'id' => 34,
                    'name' => 'Bon Sprayer',
                    'code' => '09138264',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 2,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 115.0,
                    'price' => 130.0,
                    'wholesale_price' => NULL,
                    'qty' => 338.5,
                    'alert_quantity' => 5.0,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => 1,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => '["Color"]',
                    'variant_value' => '["Red,Yellow,Green,Bule"]',
                    'is_active' => 1,
                ],
                [
                    'id' => 35,
                    'name' => 'Toffee',
                    'code' => '76722958',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 10.0,
                    'price' => 20.0,
                    'wholesale_price' => NULL,
                    'qty' => 48.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 36,
                    'name' => 'AMD RYZEN 5 5600G',
                    'code' => '1001',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 2,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 2500.0,
                    'price' => 3500.0,
                    'wholesale_price' => NULL,
                    'qty' => 6.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 37,
                    'name' => 'KINGSTON 8GB RAM',
                    'code' => '1002',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 2,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 1000.0,
                    'price' => 1450.0,
                    'wholesale_price' => NULL,
                    'qty' => 8.0,
                    'alert_quantity' => 5.0,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202403080446151.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 38,
                    'name' => 'MI BUILD PACKAGE',
                    'code' => '1004',
                    'type' => 'combo',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 1,
                    'unit_id' => 0,
                    'purchase_unit_id' => 0,
                    'sale_unit_id' => 0,
                    'cost' => 0.0,
                    'price' => 4950.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202403080452061.JPG',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => '36,37',
                    'variant_list' => ',',
                    'qty_list' => '1,1',
                    'price_list' => '3500,1450',
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 39,
                    'name' => 'Irene Jack',
                    'code' => '3456',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => NULL,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 1000.0,
                    'price' => 899.0,
                    'wholesale_price' => NULL,
                    'qty' => 84.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 41,
                    'name' => 'off white Tshirt',
                    'code' => '75308742',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => NULL,
                    'category_id' => 39,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 4.8,
                    'price' => 8.0,
                    'wholesale_price' => NULL,
                    'qty' => -1.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 42,
                    'name' => 'test',
                    'code' => '125',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 12.0,
                    'price' => 124.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => -1.0,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 43,
                    'name' => 'samsung laptop',
                    'code' => '65317202',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 50000.0,
                    'price' => 55000.0,
                    'wholesale_price' => NULL,
                    'qty' => -5.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => 1,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 44,
                    'name' => 'samsung laptop 15',
                    'code' => '67600232',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 55000.0,
                    'price' => 60000.0,
                    'wholesale_price' => NULL,
                    'qty' => 3.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => 1,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 45,
                    'name' => 'TAKA',
                    'code' => '81639204',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 3000.0,
                    'price' => 3500.0,
                    'wholesale_price' => NULL,
                    'qty' => 2.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => 1,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => 1,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 47,
                    'name' => 'Apple 14',
                    'code' => 'apple14',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 3,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 80000.0,
                    'price' => 85000.0,
                    'wholesale_price' => NULL,
                    'qty' => 19.0,
                    'alert_quantity' => 5.0,
                    'daily_sale_objective' => 10.0,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 2,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => 1,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 48,
                    'name' => 'Laptop11',
                    'code' => '1111111',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 30000.0,
                    'price' => 32500.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => 2.0,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 49,
                    'name' => 'Shirt',
                    'code' => '112233',
                    'type' => 'service',
                    'barcode_symbology' => 'C39',
                    'brand_id' => 1,
                    'category_id' => 1,
                    'unit_id' => 0,
                    'purchase_unit_id' => 0,
                    'sale_unit_id' => 0,
                    'cost' => 0.0,
                    'price' => 10.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 50,
                    'name' => '14 pro max',
                    'code' => '34692007',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 15000.0,
                    'price' => 16000.0,
                    'wholesale_price' => NULL,
                    'qty' => 4.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => 1,
                    'is_variant' => 1,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => 1,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => '["RAM | ROM","Color"]',
                    'variant_value' => '["128GB,256GB,512GB","SpaceBlack,Silver,Gold,DeepPurple"]',
                    'is_active' => 1,
                ],
                [
                    'id' => 51,
                    'name' => 'Iphone 15 Pro Max',
                    'code' => '63028277',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 0.0,
                    'price' => 0.0,
                    'wholesale_price' => NULL,
                    'qty' => 145.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202405130525171.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => 1,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => 1,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => '["Condition","RAM | ROM","Color"]',
                    'variant_value' => '["Brand New,Pre-Owned","256GB,512GB","BlackTitanium,WhiteTitanium,BlueTitanium,NaturalTitanium"]',
                    'is_active' => 1,
                ],
                [
                    'id' => 52,
                    'name' => 'Product Test',
                    'code' => 'KK',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 1,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 44.0,
                    'price' => 23.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => '2024-05-18',
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202405180442251.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => 1,
                    'is_batch' => NULL,
                    'is_diffPrice' => 1,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => '["Quantity","Size","Price","Color"]',
                    'variant_value' => '["3KG,2KG,5KG","Large,Medium,Small","120,500,70","RED,GReen,Blue"]',
                    'is_active' => 1,
                ],
                [
                    'id' => 58,
                    'name' => 'PRUEBA',
                    'code' => '000',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 3,
                    'unit_id' => 9,
                    'purchase_unit_id' => 9,
                    'sale_unit_id' => 9,
                    'cost' => 7.0,
                    'price' => 7.0,
                    'wholesale_price' => 7.0,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202406111018041.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 59,
                    'name' => 'Prueba Easy',
                    'code' => '190',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 3,
                    'unit_id' => 4,
                    'purchase_unit_id' => 4,
                    'sale_unit_id' => 4,
                    'cost' => 777.0,
                    'price' => 777.0,
                    'wholesale_price' => 777.0,
                    'qty' => 0.0,
                    'alert_quantity' => 120.0,
                    'daily_sale_objective' => 65.0,
                    'promotion' => 1,
                    'promotion_price' => '150',
                    'starting_date' => '2024-06-11',
                    'last_date' => '2024-06-20',
                    'tax_id' => 1,
                    'tax_method' => 1,
                    'image' => '202406111023031.jpg',
                    'file' => NULL,
                    'is_embeded' => 1,
                    'is_variant' => 1,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => 1,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => '["BLANCO","NEGRO"]',
                    'variant_value' => '["199","299"]',
                    'is_active' => 1,
                ],
                [
                    'id' => 60,
                    'name' => 'Producto Prueba',
                    'code' => '777',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 4,
                    'unit_id' => 4,
                    'purchase_unit_id' => 4,
                    'sale_unit_id' => 4,
                    'cost' => 200.0,
                    'price' => 200.0,
                    'wholesale_price' => 200.0,
                    'qty' => 0.0,
                    'alert_quantity' => 10.0,
                    'daily_sale_objective' => 10.0,
                    'promotion' => 1,
                    'promotion_price' => '175',
                    'starting_date' => NULL,
                    'last_date' => '2024-06-25',
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202406111027511.png,202406111027512.jpg,202406111027513.jpg,202406111027514.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => 1,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>Prueba de imagenes easymax</p>',
                    'variant_option' => '["NEGRO","NEGRO","NEGRO","NEGRO"]',
                    'variant_value' => '["255","255","255","255"]',
                    'is_active' => 1,
                ],
                [
                    'id' => 61,
                    'name' => 'IPHONE 14 PRO MAX',
                    'code' => '01234',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 3,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 1500.0,
                    'price' => 1500.0,
                    'wholesale_price' => 1499.0,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => 15.0,
                    'promotion' => 1,
                    'promotion_price' => '1299',
                    'starting_date' => '2024-06-11',
                    'last_date' => '2024-06-25',
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202406111040331.jpg,202406111040342.jpg,202406111040343.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => 1,
                    'is_batch' => NULL,
                    'is_diffPrice' => 1,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p><a class=@sh-anchor@ href=@https://www.bing.com/ck/a?!&amp;&amp;p=3057d02af68c6961JmltdHM9MTcxODA2NDAwMCZpZ3VpZD0zZTNlNjhiMy1jOTY5LTZkYzYtMzJjMS03Y2Q0Yzg1NjZjMDUmaW5zaWQ9NjU4Mw&amp;ptn=3&amp;ver=2&amp;hsh=3&amp;fclid=3e3e68b3-c969-6dc6-32c1-7cd4c8566c05&amp;psq=apple+descripcion&amp;u=a1aHR0cHM6Ly9odW1hbmlkYWRlcy5jb20vYXBwbGUv&amp;ntb=1@ target=@_blank@ rel=@noopener@ data-tg-citations=@1;2@ data-tgpsgid=@d_anstgsen0@>Apple es una&nbsp;<strong>empresa multinacional estadounidense que dise&ntilde;a, fabrica y vende productos electr&oacute;nicos y de software</strong></a><a class=@sup-target@ href=@https://www.bing.com/ck/a?!&amp;&amp;p=d1b09c46723a5d2aJmltdHM9MTcxODA2NDAwMCZpZ3VpZD0zZTNlNjhiMy1jOTY5LTZkYzYtMzJjMS03Y2Q0Yzg1NjZjMDUmaW5zaWQ9NjU4NA&amp;ptn=3&amp;ver=2&amp;hsh=3&amp;fclid=3e3e68b3-c969-6dc6-32c1-7cd4c8566c05&amp;psq=apple+descripcion&amp;u=a1aHR0cHM6Ly9odW1hbmlkYWRlcy5jb20vYXBwbGUv&amp;ntb=1@ target=@_blank@ rel=@noopener@ data-tgpsgid=@d_anstgpsg1@><sup>1</sup></a><a class=@sup-target@ href=@https://www.bing.com/ck/a?!&amp;&amp;p=21491c7be3d7d5d9JmltdHM9MTcxODA2NDAwMCZpZ3VpZD0zZTNlNjhiMy1jOTY5LTZkYzYtMzJjMS03Y2Q0Yzg1NjZjMDUmaW5zaWQ9NjU4NQ&amp;ptn=3&amp;ver=2&amp;hsh=3&amp;fclid=3e3e68b3-c969-6dc6-32c1-7cd4c8566c05&amp;psq=apple+descripcion&amp;u=a1aHR0cHM6Ly93d3cuMTJjYXJhY3RlcmlzdGljYXMuY29tL2FwcGxlLw&amp;ntb=1@ target=@_blank@ rel=@noopener@ data-tgpsgid=@d_anstgpsg2@><sup>2</sup></a>.&nbsp;<a class=@sh-anchor@ href=@https://www.bing.com/ck/a?!&amp;&amp;p=c80ea6db0a534e3eJmltdHM9MTcxODA2NDAwMCZpZ3VpZD0zZTNlNjhiMy1jOTY5LTZkYzYtMzJjMS03Y2Q0Yzg1NjZjMDUmaW5zaWQ9NjU4Ng&amp;ptn=3&amp;ver=2&amp;hsh=3&amp;fclid=3e3e68b3-c969-6dc6-32c1-7cd4c8566c05&amp;psq=apple+descripcion&amp;u=a1aHR0cHM6Ly93d3cuMTJjYXJhY3RlcmlzdGljYXMuY29tL2FwcGxlLw&amp;ntb=1@ target=@_blank@ rel=@noopener@ data-tg-citations=@2@ data-tgpsgid=@d_anstgsen1@>Entre sus productos m&aacute;s conocidos se encuentran el iPhone, el iPad, el Mac, el iPod, el Apple Watch y el Apple TV. Tambi&eacute;n ofrece servicios en l&iacute;nea como iTunes, iCloud, Apple Music y Apple Pay. Apple tiene su sede en el Apple Park, en Cupertino, California, y su centro europeo en Cork, Irlanda</a></p>',
                    'variant_option' => '["Color Blanco","Color Rosa","RAM","Almacenamiento","Color Blanco","Color Rosa","RAM","Almacenamiento","Color Blanco","Color Rosa","RAM","Almacenamiento"]',
                    'variant_value' => '["1600","1699","8,16,32","32,64,128","1600","1699","8,16,32","32,64,128","1600","1699","8,16,32","32,64,128"]',
                    'is_active' => 1,
                ],
                [
                    'id' => 62,
                    'name' => 'T-Shirt',
                    'code' => '003',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => NULL,
                    'category_id' => 4,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 8000.0,
                    'price' => 9500.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => 3.0,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => '2024-06-21',
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202406210233561.jpg',
                    'file' => NULL,
                    'is_embeded' => 1,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 63,
                    'name' => 'Laptop',
                    'code' => '83058761',
                    'type' => 'standard',
                    'barcode_symbology' => 'C39',
                    'brand_id' => 2,
                    'category_id' => 6,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 1000.0,
                    'price' => 2000.0,
                    'wholesale_price' => 500.0,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 64,
                    'name' => 'Glass',
                    'code' => '37580174',
                    'type' => 'standard',
                    'barcode_symbology' => 'UPCA',
                    'brand_id' => 10,
                    'category_id' => 4,
                    'unit_id' => 4,
                    'purchase_unit_id' => 4,
                    'sale_unit_id' => 5,
                    'cost' => 70.0,
                    'price' => 100.0,
                    'wholesale_price' => 60.0,
                    'qty' => 0.0,
                    'alert_quantity' => 5.0,
                    'daily_sale_objective' => 3.0,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202407010954551.png',
                    'file' => NULL,
                    'is_embeded' => 1,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 65,
                    'name' => 'test prod',
                    'code' => '862837',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 3,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 100.0,
                    'price' => 150.0,
                    'wholesale_price' => 120.0,
                    'qty' => 27.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 3,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => 1,
                    'is_variant' => 1,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<p>test desc</p>',
                    'variant_option' => '["Size","Colour"]',
                    'variant_value' => '["S,M,L","R,g,b"]',
                    'is_active' => 1,
                ],
                [
                    'id' => 66,
                    'name' => 'Earphone True Wireless G70',
                    'code' => '2312021280054',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 3,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 58.0,
                    'price' => 17.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => '202409080650101.jpg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '<h1 style=@text-align: right;@>هیدفۆنی وایەرلێس جی٧٠</h1>
                    <p style=@text-align: right;@>&nbsp;</p>
                    <h2 style=@text-align: right;@>تایبەتمەندیەکانی</h2>
                    <p style=@text-align: right;@>هیدفۆنی بێ وایەر</p>
                    <p style=@text-align: right;@>سیستەمی گونجاو :&nbsp;ئەندرۆید / ئی ئۆ ئێس / ویندۆس</p>
                    <p style=@text-align: right;@>وەشانی بلوتوز :&nbsp;٥.٣</p>
                    <p style=@text-align: right;@>توانای پاتری :&nbsp;٣٠ میلی ئەمپێر</p>
                    <p style=@text-align: right;@>توانای پاتری سندوقی شەحنکردنەوە :&nbsp;٢٥٠ میلی ئەمپێر</p>
                    <p style=@text-align: right;@>شێوازی شەحنکردنەوە :&nbsp;شەحنکردنەوەی جۆری سی</p>
                    <p style=@text-align: right;@>تەمەنی پاتری : نزیکەی ٤ بۆ ٥ کاتژمێر</p>
                    <p style=@text-align: right;@>&nbsp;</p>
                    <h1>Earphone True Wireless G70</h1>
                    <p style=@text-align: justify;@>&nbsp;</p>
                    <h2>Specification</h2>
                    <p>Product Type :&nbsp;Wireless Earbuds</p>
                    <p>Brand :&nbsp;UiiSii</p>
                    <p>Model :&nbsp;TWS-G70</p>
                    <p>Compatible Systems :&nbsp;ios/android/Windows</p>
                    <p>Bluetooth Version :&nbsp;5.3</p>
                    <p>Battery Capacity :&nbsp;30 mAh</p>
                    <p>Charging Box Battery Capacity :&nbsp;250 mAh</p>
                    <p>Charging Method :&nbsp;TYPE-C charging</p>
                    <p>Buds Battery Life :&nbsp;About 4 to 5 hours</p>
                    <p>&nbsp;</p>',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 67,
                    'name' => 'T shirt',
                    'code' => '07116185',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 1,
                    'category_id' => 3,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 500.0,
                    'price' => 1000.0,
                    'wholesale_price' => 700.0,
                    'qty' => 0.0,
                    'alert_quantity' => 100.0,
                    'daily_sale_objective' => 100.0,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => '2024-10-12',
                    'last_date' => NULL,
                    'tax_id' => NULL,
                    'tax_method' => 1,
                    'image' => 'zummXD2dvAtI.png',
                    'file' => NULL,
                    'is_embeded' => 1,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ],
                [
                    'id' => 68,
                    'name' => 'kannadasan yogaraja',
                    'code' => '38259140',
                    'type' => 'standard',
                    'barcode_symbology' => 'C128',
                    'brand_id' => 2,
                    'category_id' => 2,
                    'unit_id' => 1,
                    'purchase_unit_id' => 1,
                    'sale_unit_id' => 1,
                    'cost' => 200.0,
                    'price' => 10.0,
                    'wholesale_price' => NULL,
                    'qty' => 0.0,
                    'alert_quantity' => NULL,
                    'daily_sale_objective' => NULL,
                    'promotion' => NULL,
                    'promotion_price' => NULL,
                    'starting_date' => NULL,
                    'last_date' => NULL,
                    'tax_id' => 3,
                    'tax_method' => 1,
                    'image' => '202410261213471.png,202410261213482.jpeg',
                    'file' => NULL,
                    'is_embeded' => NULL,
                    'is_variant' => NULL,
                    'is_batch' => NULL,
                    'is_diffPrice' => NULL,
                    'is_imei' => NULL,
                    'featured' => NULL,
                    'product_list' => NULL,
                    'variant_list' => NULL,
                    'qty_list' => NULL,
                    'price_list' => NULL,
                    'product_details' => '',
                    'variant_option' => NULL,
                    'variant_value' => NULL,
                    'is_active' => 1,
                ]
            ]);
        }

        if (!DB::table('purchases')->count()) {
            DB::table('purchases')->insert([
                [
                    'id' => 1,
                    'reference_no' => 'pr-20230528-125929',
                    'user_id' => 1,
                    'warehouse_id' => 1,
                    'supplier_id' => NULL,
                    'currency_id' => 1,
                    'exchange_rate' => 1.0,
                    'item' => 1,
                    'total_qty' => 10,
                    'total_discount' => 0.0,
                    'total_tax' => 10.0,
                    'total_cost' => 110.0,
                    'order_tax_rate' => 0.0,
                    'order_tax' => 0.0,
                    'order_discount' => 0.0,
                    'shipping_cost' => 0.0,
                    'grand_total' => 110.0,
                    'paid_amount' => 0.0,
                    'status' => 1,
                    'payment_status' => 1,
                    'document' => NULL,
                    'note' => NULL,
                ]
            ]);
        }

        if (!DB::table('suppliers')->count()) {
            DB::table('suppliers')->insert([
                [
                    'id' => 1,
                    'name' => 'John Doe',
                    'image' => NULL,
                    'company_name' => 'Test Company',
                    'vat_number' => NULL,
                    'email' => 'john@gmail.com',
                    'phone_number' => '231312',
                    'address' => 'Test address',
                    'city' => 'Test City',
                    'state' => NULL,
                    'postal_code' => NULL,
                    'country' => NULL,
                    'is_active' => 1,
                ]
            ]);
        }

        if (!DB::table('taxes')->count()) {
            DB::table('taxes')->insert([
                [
                    'id' => 1,
                    'name' => 'VAT 10%',
                    'rate' => 10.0,
                    'is_active' => 1,
                ]
            ]);
        }

        if (!DB::table('units')->count()) {
            DB::table('units')->insert([
                [
                    'id' => 1,
                    'unit_code' => 'Pc',
                    'unit_name' => 'piece',
                    'base_unit' => NULL,
                    'operator' => '*',
                    'operation_value' => 1.0,
                    'is_active' => 1,
                ]
            ]);
        }

        if (!DB::table('warehouses')->count()) {
            DB::table('warehouses')->insert([
                [
                    'id' => 1,
                    'name' => 'Test Shop',
                    'phone' => '9991111',
                    'email' => NULL,
                    'address' => 'Test address',
                    'is_active' => 1,
                ]
            ]);
        }
    }
}
