<?php
    $layout = config('database.connections.saleprosaas_landlord') ? 'landlord.layout.main' : 'backend.layout.main';
?>



<?php $__env->startSection('title','Admin | New Release Version'); ?>
<?php $__env->startSection('content'); ?>

    <?php if(session()->has('message')): ?>
    <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close"
            data-dismiss="alert" aria-label="Close"><span
                aria-hidden="true">&times;</span></button><?php echo session()->get('message'); ?></div>
    <?php endif; ?>
    <?php if(session()->has('not_permitted')): ?>
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close"
            data-dismiss="alert" aria-label="Close"><span
                aria-hidden="true">&times;</span></button><?php echo e(session()->get('not_permitted')); ?></div>
    <?php endif; ?>

    <?php if(isset($versionUpgradeData['alert_version_upgrade_enable']) &&
            $versionUpgradeData['alert_version_upgrade_enable'] == true): ?>
        <?php if(!empty($versionUpgradeData['advertise_info'])): ?>
        <section id="adSection" class="container text-center">
            <div class="card">
                <div class="card-body">
                    <?php echo $versionUpgradeData['advertise_info']; ?>

                </div>
            </div>
        </section>
        <?php endif; ?>
        <!-- For New Version -->
        <section id="newVersionSection" class="container text-center">
            <div class="card">
                <div class="card-body">
                    <h4 class="text-center text-success"> A new version <b><?php echo e($versionUpgradeData['demo_version']); ?></b> has
                        been released.</h4>
                    <p>Before upgrading, we highly recomended you to keep a backup of your current script and database.</p>
                    <p><a target="_blank" href="<?php echo e(config('database.connections.saleprosaas_landlord') ? 'https://lion-coders.com/software/salepro-saas-pos-inventory-saas-php-script' : 'https://lion-coders.com/software/salepro-inventory-management-system-with-pos-hrm-accounting'); ?>">Change Log</a></p>
                </div>
            </div>

            <div class="d-flex justify-content-center mt-3 mb-3">
                <div id="spinner" class="d-none spinner-border text-success" role="status">
                    <span class="sr-only">Loading...</span>
                </div>
            </div>
            <form action="<?php echo e(config('database.connections.saleprosaas_landlord') ? route('saas-version-upgrade') : route('version-upgrade')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <label>Purchase Code</label>
		        <input type='text' placeholder="Ex: 123456789XXXXXXXX" required class="form-control" name="purchasecode">
                <button type="submit" class="mt-5 mb-5 btn btn-primary btn-lg">Upgrade</button>
            </form>
        </section>
    <?php else: ?>
        <!-- Cuurent Version -->
        <section id="oldVersionSection" class="container mt-5 text-center">
            <div class="card">
                <div class="card-body">
                    <h4 class="text-center text-info">Your current version is <span><?php echo e(env('VERSION')); ?></span></h4>
                    <p>Please wait for upcoming version</p>
                </div>
            </div>
        </section>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $("#upgrade-form").on("submit", function() {
            $(".upgrade-btn").prop("disabled", true);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xamppp\htdocs\Script\resources\views/version_upgrade/index.blade.php ENDPATH**/ ?>