<?php
    $decimal = config('decimal');
    $currency = config('currency');
    $currency_position = config('currency_position');
    
    if (!$currency) $currency = config('currency');
?>

<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'amount',
    'currency_symbol' => $currency,
    'currency_position' => $currency_position,
    'decimal' => $decimal,
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'amount',
    'currency_symbol' => $currency,
    'currency_position' => $currency_position,
    'decimal' => $decimal,
]); ?>
<?php foreach (array_filter(([
    'amount',
    'currency_symbol' => $currency,
    'currency_position' => $currency_position,
    'decimal' => $decimal,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php if(strlen($currency_symbol) > 1): ?>
    <?php if($currency_position == 'prefix'): ?>
        <span><?php echo e($currency_symbol); ?>&nbsp;<?php echo e(number_format((float) $amount, $decimal, '.', ',')); ?></span>
    <?php else: ?>
        <span><?php echo e(number_format((float) $amount, $decimal, '.', ',')); ?>&nbsp;<?php echo e($currency_symbol); ?></span>
    <?php endif; ?>
<?php else: ?>
    <?php if($currency_position == 'prefix'): ?>
        <span><?php echo e($currency_symbol); ?><?php echo e(number_format((float) $amount, $decimal, '.', ',')); ?></span>
    <?php else: ?>
        <span><?php echo e(number_format((float) $amount, $decimal, '.', ',')); ?><?php echo e($currency_symbol); ?></span>
    <?php endif; ?>
<?php endif; ?><?php /**PATH C:\xamppp\htdocs\Script\resources\views/components/amount-currency-symbol.blade.php ENDPATH**/ ?>