
<?php $__env->startPush('css'); ?>
    <style>
        #table-loader {
            background-color: #f9f9f9;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('includes.session_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <div class="container mt-5">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><?php echo e(__('db.Invoice Settings')); ?></h2>
        </div>

        <div class=" mb-3 ">
            <a class="btn btn-primary float-end" href="<?php echo e(route('settings.invoice.create')); ?>"> <i class="dripicons-plus"></i>
                <?php echo e(__('db.Add New Invoice Setting')); ?></a>
        </div>



        <table class="table table-bordered">
            <thead class="table-secondary">
                <tr>
                    <th class="col-3"><?php echo e(__('db.Template Name')); ?></th>
                    <th class="col-2"><?php echo e(__('db.Size')); ?></th>
                    <th class="col-2  text-center"><?php echo e(__('db.Default')); ?></th>
                    <th class="col-3 text-center"><?php echo e(__('db.action')); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr id="table-loader" style="display: none;">
                    <td colspan="5" class="text-center">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden"></span>
                        </div>
                    </td>
                </tr>
                <?php $__empty_1 = true; $__currentLoopData = $invoiceSettings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($invoice->template_name); ?></td>
                        <td><?php echo e($invoice->size); ?></td>
                        <td class="text-center align-middle">
                            <?php if($invoice->is_default): ?>
                                <span class="badge bg-success"><?php echo e(__('db.Default')); ?></span>
                            <?php else: ?>
                                <button class="btn btn-sm btn-outline-secondary change-status" data-id="<?php echo e($invoice->id); ?>"
                                    data-column="is_default" data-url="<?php echo e(route('settings.invoice.update', $invoice->id)); ?>">
                                    <?php echo e(__('db.Set Default')); ?>

                                </button>
                            <?php endif; ?>
                        </td>



                        <td class="text-center align-middle">
                            <a class="btn btn-warning btn-sm"
                                href="<?php echo e(route('settings.invoice.edit', $invoice->id)); ?>"></i><?php echo e(__('db.update')); ?></a>
                            <button class="btn btn-danger btn-sm delete-invoice" data-id="<?php echo e($invoice->id); ?>"
                                data-url="<?php echo e(route('settings.invoice.destroy', $invoice->id)); ?>"><?php echo e(__('db.delete')); ?></button>
                            
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php endif; ?>

            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('.delete-invoice').on('click', function() {
                var button = $(this);
                var id = button.data('id');
                var url = button.data('url');
                var row = button.closest('tr');

                if (confirm('Are you sure you want to delete this invoice setting?')) {
                    $('#table-loader').show(); // Show loader row

                    $.ajax({
                        url: url,
                        type: 'POST',
                        data: {
                            _method: 'DELETE',
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function(response) {
                            if (response.success == true) {
                                row.fadeOut(400, function() {
                                    $(this).remove();
                                });
                            }else if (response.success == false){
                                alert('Default invoice cannot be deleted');
                            } else {
                                alert(response.not_permitted);
                            }

                        },
                        error: function() {
                            alert('Error deleting invoice.');
                        },
                        complete: function() {
                            $('#table-loader').hide();
                        }
                    });
                }
            });

            $('.change-status').on('click', function() {
                var button = $(this);
                var id = button.data('id');
                var url = button.data('url');
                var column = button.data('column');
                console.log(id, url, column)
                if (confirm('Are you sure you want to change the status?')) {
                    $.ajax({
                        url: url,
                        method: 'POST',
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            _method: 'PUT', // important if you're using Laravel's resourceful routes
                            id: id,
                            column: column
                        },
                        success: function() {
                            location.reload();
                        },
                        error: function() {
                            alert("Failed to update status.");
                        }
                    });
                }
            })

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xamppp\htdocs\Script\resources\views/backend/setting/invoice_setting/index.blade.php ENDPATH**/ ?>