<!DOCTYPE html>
<html>
<?php
    $show = json_decode($invoice_settings->show_column);
?>

<head>
    <link rel="icon" type="image/png" href="<?php echo e(url('logo', $general_setting->site_logo)); ?>" />
    <title><?php echo e($lims_sale_data->customer->name . '_Sale_' . $lims_sale_data->reference_no); ?></title>
    <?php
        $primary_color =
            isset($show->active_primary_color) &&
            $show->active_primary_color == 1 &&
            !empty($invoice_settings->primary_color)
                ? $invoice_settings->primary_color
                : '#014b94';
    ?>
    <style type="text/css">
        span,
        td {
            font-size: 13px;
            line-height: 1.4;
        }

        @media print {
            .hidden-print {
                display: none !important;
            }

            tr.table-header {
                background-color: <?php echo e($primary_color); ?> !important;
                -webkit-print-color-adjust: exact;
            }

            td.td-text {
                background-color: rgb(205, 218, 235) !important;
                -webkit-print-color-adjust: exact;
            }
        }

        table,
        tr,
        td {
            font-family: sans-serif;
            border-collapse: collapse;
        }
    </style>
</head>

<body>

    <?php if(preg_match('~[0-9]~', url()->previous())): ?>
        <?php $url = '../../pos'; ?>
    <?php else: ?>
        <?php $url = url()->previous(); ?>
    <?php endif; ?>
    <div class="hidden-print">
        <table>
            <tr>
                <td><a href="<?php echo e($url); ?>" class="btn btn-info"><i class="fa fa-arrow-left"></i>
                        <?php echo e(__('db.Back')); ?></a> </td>
                <td><button onclick="window.print();" class="btn btn-primary"><i class="dripicons-print"></i>
                        <?php echo e(__('db.Print')); ?></button></td>
            </tr>
        </table>
        <br>
    </div>
    <table style="width: 100%;border-collapse: collapse;">
        <tr>
            <td colspan="2" style="padding:9px 0;width:40%">
                <?php if(isset($show->show_warehouse_info) && $show->show_warehouse_info == 1): ?>
                    <h1 style="margin:0"><?php echo e($general_setting->company_name ?? $lims_biller_data->company_name); ?></h1>
                    <div>
                        <span><?php echo e(__('db.Address')); ?>:</span>&nbsp;&nbsp;<span><?php echo e($lims_warehouse_data->address); ?></span>
                    </div>
                    <div>
                        <span><?php echo e(__('db.Phone')); ?>:</span>&nbsp;&nbsp;<span><?php echo e($lims_warehouse_data->phone); ?></span>
                    </div>
                    <?php if($general_setting->vat_registration_number && isset($show->show_vat_registration_number) && $show->show_vat_registration_number == 1): ?>
                        <div>
                            <span><?php echo e(__('db.VAT Number')); ?>:</span>&nbsp;&nbsp;<span><?php echo e($general_setting->vat_registration_number); ?></span>
                        </div>
                    <?php endif; ?>

                <?php endif; ?>
            </td>
            <td style="width:30%; text-align: middle; vertical-align: top;">
                <?php if($general_setting->site_logo || $invoice_settings->company_logo): ?>
                    <img src="<?php echo e($invoice_settings->company_logo ? url('invoices', $invoice_settings->company_logo) : url('logo', $general_setting->site_logo)); ?>"
                        height="<?php echo e($invoice_settings->logo_height ?? auto); ?>"
                        width="<?php echo e($invoice_settings->logo_width ?? auto); ?>" style="margin:5px 0;">
                <?php endif; ?>
            </td>
            <td style="padding:5px -19px;width:30%;text-align:right;">
                <div style="display: flex;justify-content: space-between;border-bottom:1px solid #aaa">
                    <span><?php echo e(__('db.reference')); ?>:</span> <span><?php echo e($lims_sale_data->reference_no); ?></span>
                </div>
                <div style="display: flex;justify-content: space-between;border-bottom:1px solid #aaa">
                    <span><?php echo e(__('db.date')); ?>:</span>
                    <?php if(isset($show->active_date_format) && $show->active_date_format == 1): ?>
                        <?php echo e(Carbon\Carbon::parse($lims_sale_data->created_at)->format($invoice_settings->invoice_date_format)); ?>

                    <?php else: ?>
                        <?php echo e($lims_sale_data->created_at); ?>

                    <?php endif; ?>
                </div>
                <?php if($paid_by_info): ?>
                    <div style="display: flex;justify-content: space-between;border-bottom:1px solid #aaa">
                        <span><?php echo e(__('db.Paid By')); ?>:</span> <span><?php echo e($paid_by_info); ?></span>
                    </div>
                <?php endif; ?>

                <?php if(isset($show->show_biller_info) && $show->show_biller_info == 1): ?>
                    <div style="display: flex;justify-content: space-between;border-bottom:1px solid #aaa">
                        <span><?php echo e(__('db.Served By')); ?>:</span> <span><?php echo e($lims_bill_by['name']); ?> -
                            (<?php echo e($lims_bill_by['user_name']); ?>)</span>
                    </div>
                <?php endif; ?>
                <?php
                foreach ($sale_custom_fields as $key => $fieldName) {
                    $field_name = str_replace(' ', '_', strtolower($fieldName));
                    echo '<div style="display: flex;justify-content: space-between;border-bottom:1px solid #aaa"><span>' . $fieldName . ':</span> <span> ' . $lims_sale_data->$field_name . '</span></div>';
                }
                foreach ($customer_custom_fields as $key => $fieldName) {
                    $field_name = str_replace(' ', '_', strtolower($fieldName));
                    echo '<div style="display: flex;justify-content: space-between;border-bottom:1px solid #aaa"><span>' . $fieldName . ':</span> <span>' . $lims_customer_data->$field_name . '</span></div>';
                }
                ?>
            </td>
        </tr>
    </table>
    <table style="width: 100%;border-collapse: collapse; margin-top: 4px;">
        <tr>
            <?php if(isset($show->show_bill_to_info) && $show->show_bill_to_info == 1): ?>
                <td colspan="3" style="padding:4px 0;width:30%;vertical-align:top">
                    <h2
                        style="background-color: <?php echo e(isset($show->active_primary_color) &&
                        $show->active_primary_color == 1 &&
                        !empty($invoice_settings->primary_color)
                            ? $invoice_settings->primary_color
                            : '#014b94'); ?>; color: white; padding: 3px 10px; margin-bottom: 0;">
                        Bill To
                    </h2>
                    <div style="margin-top: 10px;margin-left: 10px">
                        <span><?php echo e(__('db.customer')); ?>: <?php echo e($lims_customer_data->name); ?></span>
                    </div>
                    
                    <div style="margin-left: 10px">

                        <span><?php echo e(__('db.Address')); ?>:</span>&nbsp;&nbsp;
                        <?php if($lims_sale_data->sale_type == 'online'): ?>
                            <span><?php echo e($lims_sale_data->shipping_name); ?>, <?php echo e($lims_sale_data->shipping_address); ?>,
                                <?php echo e($lims_sale_data->shipping_city); ?>, <?php echo e($lims_sale_data->shipping_country); ?>,
                                <?php echo e($lims_sale_data->shipping_zip); ?></span>
                        <?php else: ?>
                            <span><?php echo e($lims_customer_data->address); ?></span>
                        <?php endif; ?>
                    </div>
                    <?php if(isset($lims_customer_data->phone_number) || isset($lims_sale_data->shipping_phone)): ?>
                        <div style="margin-bottom: 10px;margin-left: 10px">
                            <span>Phone:</span>&nbsp;&nbsp;
                            <?php if($lims_sale_data->sale_type == 'online'): ?>
                                <span><?php echo e($lims_sale_data->shipping_phone); ?>

                                <?php else: ?>
                                    <span><?php echo e($lims_customer_data->phone_number); ?></span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </td>
            <?php endif; ?>

        </tr>
    </table>
    <table dir="<?php if(Config::get('app.locale') == 'ar' || $general_setting->is_rtl): ?> <?php echo e('rtl'); ?> <?php endif; ?>"
        style="width: 100%;border-collapse: collapse;">
        <tr class="table-header"
            style="background-color: <?php echo e(isset($show->active_primary_color) &&
            $show->active_primary_color == 1 &&
            !empty($invoice_settings->primary_color)
                ? $invoice_settings->primary_color
                : '#014b94'); ?>; color: white;">
            <td style="border:1px solid #222;padding:1px 3px;width:4%;text-align:center">#</td>

            <td style="border:1px solid #222;padding:1px 3px;width:49%;text-align:center"><?php echo e(__('db.Description')); ?>

            </td>
            <td style="border:1px solid #222;padding:1px 3px;width:6%;text-align:center"><?php echo e(__('db.qty')); ?></td>
            <td style="border:1px solid #222;padding:1px 3px;width:9%;text-align:center"><?php echo e(__('db.Unit Price')); ?></td>
            <td style="border:1px solid #222;padding:1px 3px;width:7%;text-align:center"><?php echo e(__('db.Total')); ?></td>
            <td style="border:1px solid #222;padding:1px 3px;width:7%;text-align:center"><?php echo e(__('db.Tax')); ?></td>
            <td style="border:1px solid #222;padding:1px 2px;width:13%;text-align:center;"><?php echo e(__('db.Subtotal')); ?></td>
        </tr>
        <?php
        $total_product_tax = 0;
        $totalPrice = 0;
        ?>

        <?php $__currentLoopData = $lims_product_sale_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product_sale_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
            $lims_product_data = \App\Models\Product::find($product_sale_data->product_id);
            if ($product_sale_data->sale_unit_id) {
                $unit = \App\Models\Unit::select('unit_code')->find($product_sale_data->sale_unit_id);
                $unit_code = $unit->unit_code;
            } else {
                $unit_code = '';
            }

            if ($product_sale_data->variant_id) {
                $variant = \App\Models\Variant::select('name')->find($product_sale_data->variant_id);
                $variant_name = $variant->name;
            } else {
                $variant_name = '';
            }
            $totalPrice += $product_sale_data->net_unit_price * $product_sale_data->qty;

            $topping_names = [];
            $topping_prices = [];
            $topping_price_sum = 0;

            if ($product_sale_data->topping_id) {
                $decoded_topping_id = is_string($product_sale_data->topping_id) ? json_decode($product_sale_data->topping_id, true) : $product_sale_data->topping_id;
                //dd(json_decode($product_sale_data->topping_id));
                if (is_array($decoded_topping_id)) {
                    foreach ($decoded_topping_id as $topping) {
                        $topping_names[] = $topping['name']; // Extract name
                        $topping_prices[] = $topping['price']; // Extract price
                        $topping_price_sum += $topping['price']; // Sum up prices
                    }
                }
            }

            $net_price_with_toppings = $product_sale_data->net_unit_price + $topping_price_sum;
            $total = ($product_sale_data->net_unit_price + $topping_price_sum) * $product_sale_data->qty;

            $subtotal = $product_sale_data->total + $topping_price_sum;
            ?>
            <tr>
                <td
                    style="<?php if(Config::get('app.locale') == 'ar' || $general_setting->is_rtl): ?> <?php echo e('border-right:1px solid #222;'); ?> <?php endif; ?> border:1px solid #222;padding:1px 3px;text-align: center;">
                    <?php echo e($key + 1); ?></td>
                <td style="border:1px solid #222;padding:1px 3px;font-size: 15px;line-height: 1.2;">

                    <?php echo $lims_product_data->name; ?>


                    <?php if(!empty($topping_names)): ?>
                        <br><small>(<?php echo e(implode(', ', $topping_names)); ?>)</small>
                    <?php endif; ?>

                    <?php $__currentLoopData = $product_custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $fieldName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $field_name = str_replace(' ', '_', strtolower($fieldName)); ?>
                        <?php if($lims_product_data->$field_name): ?>
                            <?php if(!$index): ?>
                                <br>
                                <span style="font-weight: bold;"><?php echo e($fieldName); ?></span>
                                <?php echo e(': ' . $lims_product_data->$field_name); ?>

                            <?php else: ?>
                                <br>
                                <span style="font-weight: bold;"><?php echo e($fieldName); ?></span>
                                <?php echo e(': ' . $lims_product_data->$field_name); ?>

                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if($product_sale_data->imei_number && !str_contains($product_sale_data->imei_number, 'null')): ?>
                        <br><small>IMEI or Serial: <?php echo e($product_sale_data->imei_number); ?></small>
                    <?php endif; ?>
                    <!-- warranty -->
                    <?php if(isset($product_sale_data->warranty_duration)): ?>
                        <br>
                        <span
                            style="font-weight: bold;">Warranty</span><?php echo e(': ' . $product_sale_data->warranty_duration); ?>

                        <br>
                        <span style="font-weight: bold;">Will
                            Expire</span><?php echo e(': ' . $product_sale_data->warranty_end); ?>

                    <?php endif; ?>
                    <!-- guarantee -->
                    <?php if(isset($product_sale_data->guarantee_duration)): ?>
                        <br>
                        <span
                            style="font-weight: bold;">Guarantee</span><?php echo e(': ' . $product_sale_data->guarantee_duration); ?>

                        <br>
                        <span style="font-weight: bold;">Will
                            Expire</span><?php echo e(': ' . $product_sale_data->guarantee_end); ?>

                    <?php endif; ?>
                </td>
                <td style="border:1px solid #222;padding:1px 3px;text-align:center">
                    <?php echo e($product_sale_data->qty . ' ' . $unit_code . ' ' . $variant_name); ?></td>
                <td style="border:1px solid #222;padding:1px 3px;text-align:center">
                    <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $product_sale_data->net_unit_price,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($product_sale_data->net_unit_price),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                    <?php if(!empty($topping_prices)): ?>
                        <br><small>+
                            <?php echo e(implode(' + ', array_map(fn($price) => number_format($price, $general_setting->decimal, '.', ','), $topping_prices))); ?></small>
                    <?php endif; ?>
                </td>
                <td style="border:1px solid #222;padding:1px 3px;text-align:center">
                    <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $total,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($total),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                </td>
                <td style="border:1px solid #222;padding:1px 3px;text-align:center">
                    <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $product_sale_data->tax,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($product_sale_data->tax),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                </td>
                <td
                    style="border:1px solid #222;border-right:1px solid #222;padding:1px 3px;text-align:center;font-size: 15px;">
                    <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $subtotal,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($subtotal),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td colspan="3" rowspan="<?php if($general_setting->invoice_format == 'gst' && $general_setting->state == 2): ?> 6 <?php else: ?> 5 <?php endif; ?>"
                style="border:1px solid #222;padding:1px 3px;text-align: center; vertical-align: top;">
                <?php if(isset($show->show_payment_note) && $show->show_payment_note == 1 && $lims_sale_data->payment_note): ?>
                    <p class="">
                        <strong><?php echo e(__('db.Payment Note')); ?>:</strong><?php echo e($lims_sale_data->payment_note); ?></p>
                <?php endif; ?>
                <?php if(isset($show->show_sale_note) && isset($lims_sale_data->sale_note) && $show->show_sale_note): ?>
                    <p class=""> <strong><?php echo e(__('db.Sale Note')); ?>:</strong><?php echo e($lims_sale_data->sale_note); ?></p>
                <?php endif; ?>
            </td>
            <td class="td-text" colspan="3"
                style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                <?php echo e(__('db.Total Before Tax')); ?>

            </td>
            <td class="td-text"
                style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $lims_sale_data->total_price - ($lims_sale_data->total_tax + $lims_sale_data->order_tax),'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->total_price - ($lims_sale_data->total_tax + $lims_sale_data->order_tax)),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
            </td>
        </tr>
        <?php if($general_setting->invoice_format == 'gst' && $general_setting->state == 1): ?>
            <tr>
                <td class="td-text" colspan="3"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                    IGST
                </td>
                <td class="td-text"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                    <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $lims_sale_data->total_tax + $lims_sale_data->order_tax,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->total_tax + $lims_sale_data->order_tax),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                </td>
            </tr>
        <?php elseif($general_setting->invoice_format == 'gst' && $general_setting->state == 2): ?>
            <tr>
                <td class="td-text" colspan="3"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                    SGST
                </td>
                <td class="td-text"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                    <?php $total_tax_amount = ($lims_sale_data->total_tax + $lims_sale_data->order_tax) / 2; ?>
                    <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $total_tax_amount,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($total_tax_amount),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                </td>
            </tr>
            <tr>
                <td class="td-text" colspan="3"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                    CGST
                </td>
                <td class="td-text"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                    <?php $total_tax_amount = ($lims_sale_data->total_tax + $lims_sale_data->order_tax) / 2; ?>
                    <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $total_tax_amount,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($total_tax_amount),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                </td>
            </tr>
        <?php else: ?>
            <tr>
                <td class="td-text" colspan="3"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                    <?php echo e(__('db.Tax')); ?>

                </td>
                <td class="td-text"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                    <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $lims_sale_data->total_tax + $lims_sale_data->order_tax,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->total_tax + $lims_sale_data->order_tax),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                </td>
            </tr>
        <?php endif; ?>
        <tr>
            <td class="td-text" colspan="3"
                style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                <?php echo e(__('db.Discount')); ?>

            </td>
            <td class="td-text"
                style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $lims_sale_data->total_discount + $lims_sale_data->order_discount,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->total_discount + $lims_sale_data->order_discount),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
            </td>
        </tr>
        <tr>
            <td class="td-text" colspan="3"
                style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                <?php echo e(__('db.Shipping Cost')); ?>

            </td>
            <td class="td-text"
                style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $lims_sale_data->shipping_cost ?? 0,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->shipping_cost ?? 0),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
            </td>

        </tr>
        <tr>
            <td class="td-text" colspan="3"
                style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                <?php echo e(__('db.grand total')); ?></td>
            <td class="td-text"
                style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $lims_sale_data->grand_total,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->grand_total),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
            </td>
        </tr>
        <tr>
            <?php if($general_setting->currency_position == 'prefix'): ?>
                <td class="td-text" colspan="3" rowspan="4"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;vertical-align: bottom;font-size: 15px; vertical-align: top;">
                    <?php if(isset($show->show_in_words) && $show->show_in_words == 1): ?>
                        <?php echo e(__('db.In Words')); ?><br><?php echo e($currency_code); ?> <span
                            style="text-transform:capitalize;font-size: 15px;"><?php echo e(str_replace('-', ' ', $numberInWords)); ?></span>
                        only
                    <?php endif; ?>
                </td>
            <?php else: ?>
                <td class="td-text" colspan="3" rowspan="4"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;vertical-align: bottom;font-size: 15px; vertical-align: top;">
                    <?php echo e(__('db.In Words')); ?>:<br><span
                        style="text-transform:capitalize;font-size: 15px;"><?php echo e(str_replace('-', ' ', $numberInWords)); ?></span>
                    <?php echo e($currency_code); ?> only
                </td>
            <?php endif; ?>
        </tr>

        <tr>
            <td class="td-text" colspan="3"
                style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                <?php echo e(__('db.Paid')); ?>

            </td>
            <td class="td-text"
                style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $lims_sale_data->paid_amount,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->paid_amount),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
            </td>
        </tr>
        <tr>
            <?php if($change_amount > 0): ?>
                <td class="td-text" colspan="3"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                    <?php echo e(__('db.Change')); ?>

                </td>
                <td class="td-text"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                    <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $change_amount,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($change_amount),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                </td>
            <?php else: ?>
                <td class="td-text" colspan="3"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                    <?php echo e(__('db.Due')); ?>

                </td>
                <td class="td-text"
                    style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                    <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $lims_sale_data->grand_total - $lims_sale_data->paid_amount,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->grand_total - $lims_sale_data->paid_amount),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                </td>
            <?php endif; ?>
        </tr>

        <?php if($totalDue && isset($show->hide_total_due)): ?>
            <tr>
                <?php if(!$show->hide_total_due): ?>
                    <td class="td-text" colspan="3"
                        style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);">
                        <?php echo e(__('db.Total Due')); ?>

                    </td>
                    <td class="td-text" colspan="4"
                        style="border:1px solid #222;padding:1px 3px;background-color:rgb(205, 218, 235);text-align: center;font-size: 15px;">
                        <?php if (isset($component)) { $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.amount-currency-symbol','data' => ['amount' => $totalDue,'currencySymbol' => $lims_sale_data->currency->symbol]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('amount-currency-symbol'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($totalDue),'currency_symbol' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($lims_sale_data->currency->symbol)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $attributes = $__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__attributesOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6)): ?>
<?php $component = $__componentOriginalf3241f28dc21204592b5ac00ad6a92f6; ?>
<?php unset($__componentOriginalf3241f28dc21204592b5ac00ad6a92f6); ?>
<?php endif; ?>
                    </td>
                <?php endif; ?>
            </tr>
        <?php endif; ?>
    </table>
    <table style="width: 100%; border-collapse: collapse;margin-top:-9px;">

        <tr>
            <td style="width: 100%; text-align: center">
                <br>
                <br>
                <?php if(isset($show->show_barcode) && $show->show_barcode == 1): ?>
                    <?php echo '<img style="max-width:100%" src="data:image/png;base64,' . DNS1D::getBarcodePNG($lims_sale_data->reference_no, 'C128') . '" alt="barcode"   />'; ?>
                <?php endif; ?>
                <br><br>
                <?php if(isset($show->show_qr_code) && $show->show_qr_code == 1): ?>
                    <?php echo '<img style="width:5%" src="data:image/png;base64,' . DNS2D::getBarcodePNG($qrText, 'QRCODE') . '" alt="barcode"   />'; ?>
                <?php endif; ?>
                <br>
            </td>
        </tr>
        <tr>
            <td>
                <?php if(isset($show->show_footer_text) && $show->show_footer_text == 1): ?>
                    <?php echo $invoice_settings->footer_text ?? __('db.Thank you for shopping with us Please come again'); ?>

                <?php endif; ?>
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        localStorage.clear();

        function auto_print() {
            window.print();

        }
        //setTimeout(auto_print, 1000);
    </script>
</body>

</html>
<?php /**PATH C:\xamppp\htdocs\Script\resources\views/backend/setting/invoice_setting/a4.blade.php ENDPATH**/ ?>